#ifndef TC_FORM_H
#define TC_FORM_H

#include <QWidget>
#include <QCloseEvent>
#include <QLineEdit>
#include <QLabel>
#include <QPushButton>
#include <QComboBox>

namespace Ui {
    class TC_Form;
}

class TC_Form : public QWidget
{
    Q_OBJECT

public:
    explicit TC_Form(QWidget *parent = 0, Qt::WindowFlags fl = 0 );
    ~TC_Form();
    // sub fuction:
    void read_polarity();
    void read_pwm_data(int);
    void tc_parameter_read();
    void read_counter();
    void object_lock(int);
    void mode_lock(int, int);

public:
    bool is_fomr_started;
    int TC_timer;

protected:
      void timerEvent ( QTimerEvent *event);
      void closeEvent ( QCloseEvent *event );
      void showEvent ( QShowEvent * );

private slots:
      void on_PwmPeriod_0_lineEdit_textEdited(const QString &arg1);

      void on_PwmDuty_0_lineEdit_textEdited(const QString &arg1);

      void on_PwmPeriod_1_lineEdit_textEdited(const QString &arg1);

      void on_PwmDuty_1_lineEdit_textEdited(const QString &arg1);

      void on_CounterSet_0_pushButton_clicked();

      void on_CounterSet_1_pushButton_clicked();

      void on_PwmSet_0_pushButton_clicked();

      void on_PwmSet_1_pushButton_clicked();

      void on_TimerSet_0_pushButton_clicked();

      void on_TimerSet_1_pushButton_clicked();

      void on_SwDec_0_pushButton_clicked();

      void on_SwDec_1_pushButton_clicked();

      void on_TcControl_0_pushButton_toggled(bool checked);

      void on_TcControl_1_pushButton_toggled(bool checked);

      void on_TcMode_0_comboBox_currentIndexChanged(int index);

      void on_TcMode_1_comboBox_currentIndexChanged(int index);

      void on_TiGatePolarity_0_checkBox_clicked(bool checked);

      void on_TiGatePolarity_1_checkBox_clicked(bool checked);

      void on_TiInputPolarity_0_checkBox_clicked(bool checked);

      void on_TiInputPolarity_1_checkBox_clicked(bool checked);

      void on_ToPolarity_0_checkBox_clicked(bool checked);

      void on_ToPolarity_1_checkBox_clicked(bool checked);

private:
    Ui::TC_Form *ui;
    QLineEdit *PwmPeriod_lineEdit[2];
    QLineEdit *PwmDuty_lineEdit[2];
    QLabel *PwmPeriodHz_label[2];
    QLabel *PwmDutyHz_label[2];
    QPushButton *TcControl_pushButton[2];
    QComboBox *TcMode_comboBox[2];
    QComboBox *TiMode_comboBox[2];
    QComboBox *ToMode_comboBox[2];
    QComboBox *Retrigger_comboBox[2];

    QLineEdit *PresetValue_lineEdit[2];
    QLabel *CurrentCounterValue_label[2];
    QLineEdit *PulseWidth_lineEdit[2];

    QPushButton *TimerSet_pushButton[2];
    QPushButton *CounterSet_pushButton[2];
    QPushButton *PwmSet_pushButton[2];
    QPushButton *SwDec_pushButton[2];
};

#endif // TC_FORM_H
